/** 
 * A module that represents a error while server start
 * @module ServerError
 */

/** A class that allows to parse a error while server start */
class ServerError {

	/**
     * Creates a new error
     * @param  {Any} error Raw error generated by Express.js
     */
	constructor(error) {
		this.error = this.getParsedError(error);
	}

	/**
 	 * Interprets the error generated by Express.js
 	 * @param  {Any}    rawError Raw error generated by Express.js
 	 * @return {String}          Understandable error description
 	 */
	getParsedError(rawError) {

		let parsedError = '';
		// console.log(rawError);

		// App is already opened or port is busy
		if (rawError && rawError.error && rawError.error.code === 'EADDRINUSE') {
			parsedError = 'busy-port';
		}

		// Incorrect SSL cert file
		if (rawError && rawError.library && rawError.library === 'PEM routines') {
			parsedError = 'corrupted-cert';
		}

		// Incorrect SSL key file
		if (rawError && rawError.library && rawError.library === 'public key routines') {
			parsedError = 'corrupted-key';
		}

		return parsedError;
	}

}

module.exports = ServerError;